<?php
define('__GIROCHECKOUT_SDK_DEBUG__',true);

/**
 * Sample code for GiroCheckout integration of a klarna refund
 *
 * @filesource
 * @package Samples
 * @version $Revision: 274 $ / $Date: 2019-09-06 14:04:44 -0400 (Fri, 06 Sep 2019) $
 */
require_once '../../GiroCheckout_SDK/GiroCheckout_SDK.php';

/**
 * Configuration of the merchants identifier, project and password
 * this information can be found in the GiroCockpit's project settings
 */
$merchantID = 0;        // Your merchant ID (Verkaufer-ID)
$projectID = 0;         // Your project ID (Projekt-ID)
$projectPassword = "";  // Your project password

/**
 * Specify reference number of the capture or preauthorization transaction that is to be refunded
 */
$strReference = "afbbc62a-c4c3-462b-b1cd-11f7aa9983ff";

$basket = [
    "basket_id" => "basket12345", // Unique identifier for the basket
    "basket_type" => "PHYSICAL", // Type of basket: DIGITAL, PHYSICAL, or MIXED
    "basket_items" => [ // List of items in the basket
        [
            "name" => "Item 1", // Name of the item
            "quantity" => [
                //"quantity_amount" => 2, // Full capture
                "quantity_amount" => 1, // Partial capture
                "quantity_unit" => "pcs" // Unit of measurement
            ],
            "unit_price" => [
                "net" => 500, // Amount excluding tax (minor unit)
                "gross" => 600, // Amount including tax (minor unit)
                "currency" => "EUR", // ISO 4217 currency code
                "tax" => 2000 // Tax percentage (with two implied decimals, e.g., 20.00%)
            ]
        ]
    ]
];

$shippingInfo = [
    "shipping_company" => "DHL",
    "shipping_method" => "DHLPackstation",
    "tracking_number" => "123456789",
    "tracking_uri" => "https://www.dhl.com/de/express/sendungsverfolgung.html?brand=DHL&AWB=123456789",
    "return_shipping_company" => "DHL US",
    "return_tracking_number" => "987654321",
    "shipping_delay" => 3
];

/* init klarna refund and parameters */
try {
  $request = new GiroCheckout_SDK_Request( GiroCheckout_SDK_TransactionType_helper::TRANS_TYPE_KLARNA_REFUND );
  $request->setSecret($projectPassword);

  $request->addParam('merchantId',$merchantID)
          ->addParam('projectId',$projectID)
          ->addParam('merchantTxId',"txid". random_int(10000,999999))
          ->addParam('amount',1200)
          ->addParam('currency','EUR')
          ->addParam('purpose','Klarna refund ' . random_int(100,999))
          ->addParam('reference', $strReference)
//          ->addParam('basket', json_encode($basket)). // Optional
//          ->addParam('shippingInfo', json_encode($shippingInfo)) // Optional

          //the hash field is auto generated by the SDK
          ->submit();

  //echo "<pre>";print_r($request->getResponseRaw());echo "</pre>";

  /* if transaction succeeded update your local system */
  if($request->requestHasSucceeded()) {
        // rc is the response code
        $rc = $request->getResponseParam('rc');

        // This is how you can get the response parameters
        $request->getResponseParam('msg');
        $request->getResponseParam('reference');
  }
  /* if the transaction did not succeed update your local system, get the responsecode and notify the customer */
  else {
        echo $request->getResponseParam('rc') . " " . $request->getResponseParam('msg') . "\n";
  }
}
catch (Exception $e) {
  echo "Exception: <br>";
  echo $e->getMessage();

  echo "<pre>";print_r($request->getResponseRaw());echo "</pre>";
}