<?php
define('__GIROCHECKOUT_SDK_DEBUG__',true);

/**
 * Sample code for GiroCheckout integration of a klarna transaction
 *
 * @filesource
 * @package Samples
 * @version $Revision: 274 $ / $Date: 2019-09-06 14:04:44 -0400 (Fri, 06 Sep 2019) $
 */
require_once '../../GiroCheckout_SDK/GiroCheckout_SDK.php';

/**
 * Configuration of the merchants identifier, project and password
 * this information can be found in the GiroCockpit's project settings
 */
$merchantID = 0;        // Your merchant ID (Verkaufer-ID)
$projectID = 0;         // Your project ID (Projekt-ID)
$projectPassword = "";  // Your project password

/* Basket element is mandatory for Klarna transactions */
/* Sum of prices must match total amount. */
$basket = [
    "basket_id" => "basket".random_int(10000,999999), // Unique identifier for the basket
    "basket_type" => "PHYSICAL", // Type of basket: DIGITAL, PHYSICAL, or MIXED
    "basket_items" => [ // List of items in the basket
        [
            "name" => "Item 1", // Name of the item
            "quantity" => [
                "quantity_amount" => 3, // Amount of units
                "quantity_unit" => "pcs" // Unit of measurement
            ],
            "unit_price" => [
                "net" => 500, // Amount excluding tax (minor unit)
                "gross" => 600, // Amount including tax (minor unit)
                "currency" => "EUR", // ISO 4217 currency code
                "tax" => 2000 // Tax percentage (with two implied decimals, e.g., 20.00%)
            ]
        ]
    ]
];

$billingAddress = [
    "title" => "Herr",
    "first_name" => "Max",
    "last_name" => "Mustermann",
    "company_name" => "Acme GmbH",
    "email" => "maxi.muster@example.com",
    "phone_contact" => [
        "phone_type" => "MOBILE",
        "phone_number" => "+491701234567"
    ],
    "address_line_1" => "Mustergasse 123",
    "address_line_2" => "Haus A",
    "address_line_3" => "Wohnung 12",
    "postal_code" => "88888",
    "city" => "Berlin",
    "state" => "Berlin",
    "country" => "DE"
];

$shippingAddress = [
    "title" => "Herr",
    "first_name" => "Max",
    "last_name" => "Mustermann",
    "company_name" => "Acme GmbH",
    "email" => "maxi.muster@example.com",
    "phone_contact" => [
        "phone_type" => "HOME",
        "phone_number" => "+49755283492987"
    ],
    "address_line_1" => "Musterstr. 1a",
    "postal_code" => "88888",
    "city" => "Berlin",
    "state" => "Berlin",
    "country" => "DE"
];

$customerInformation = [
    "customer_id" => "CUST123456",
    "date_of_birth" => "1985-06-15",
    "gender" => "MALE",
    "title" => "Herr",
    "personal_identifications" => [
        [
            "type" => "PASSPORT",
            "id" => "A1234567",
            "issued_by" => "DE" // Must be an ISO country code
        ],
        [
            "type" => "DRIVERS_LICENSE",
            "id" => "DL78901234",
            "issued_by" => "Bayrisches Verkehrsministerium für alle Leute, die gerne Auto fahren und auch die die nicht" // Free text for driver's license
        ]
    ],
    "contacts" => [
        "phone_contacts" => [
            [
                "phone_type" => "HOME",
                "phone_number" => "+442071838750"
            ]
        ]
    ]
];

/* init klarna transaction and parameters */
try {
  $request = new GiroCheckout_SDK_Request( GiroCheckout_SDK_TransactionType_helper::TRANS_TYPE_KLARNA_TRANSACTION );
  $request->setSecret($projectPassword);

  $request->addParam('merchantId',$merchantID)
        ->addParam('projectId',$projectID)
        ->addParam('merchantTxId',"txid" . random_int(10000,999999))
        ->addParam('amount',1800)
        ->addParam('currency','EUR')
        ->addParam('purpose','Klarna Test ' . random_int(100,999))
        ->addParam('urlRedirect','https://www.my-domain.de/girocheckout/redirect-klarna')
        ->addParam('urlNotify','https://www.my-domain.de/girocheckout/redirect-klarna')
//        ->addParam('type', "AUTH" ) // Default is SALE
//        ->addParam('locale', "en" ) // Default de
//        ->addParam( 'billingAddress', json_encode( $billingAddress ) ) // Optional
//        ->addParam( 'shippingAddress', json_encode( $shippingAddress ) ) // Optional
//        ->addParam( 'customerInfo', json_encode( $customerInformation ) ) // Optional
        ->addParam( 'basket', json_encode($basket))

        //the hash field is auto generated by the SDK
        ->submit();

  //echo "<pre>";print_r($request->getResponseRaw());echo "</pre>";

  /* if transaction succeeded update your local system and redirect the customer */
  if($request->requestHasSucceeded()) {
        // rc is the response code
        $rc = $request->getResponseParam('rc');

        // This is how you can get the response parameters
        $request->getResponseParam('msg');
        $request->getResponseParam('reference');
        $request->getResponseParam('redirect');

        // Redirect the customer to the payment provider
        $request->redirectCustomerToPaymentProvider();
  }
  /* if the transaction did not succeed update your local system, get the responsecode and notify the customer */
  else {
        echo $request->getResponseParam('rc') . " " . $request->getResponseParam('msg') . "\n";
  }
}
catch (Exception $e) {
  echo "Exception: <br>";
  echo $e->getMessage();

  echo "<pre>";print_r($request->getResponseRaw());echo "</pre>";
}