<?php
define('__GIROCHECKOUT_SDK_DEBUG__',true);

/**
 * Sample code for GiroCheckout integration of a payment page transaction
 *
 * Call through web server:
 * a) With reference code from original paypage transaction, parameter ref
 * http://localhost/PaypageRefund.php?ref=43290-48329043-43289
 * b) Put reference directly into this file and call only http://localhost/PaypageRefund.php
 * 
 * @filesource
 * @package Samples
 * @version $Revision: 274 $ / $Date: 2019-09-06 14:04:44 -0400 (Fri, 06 Sep 2019) $
 */
require_once '../../GiroCheckout_SDK/GiroCheckout_SDK.php';

/**
 * Configuration of the merchants identifier, project and password
 * this information can be found in the GiroCockpit's project settings
 */
$merchantID = 0;        // Your merchant ID (Verkaufer-ID)
$projectID = 0;         // Your project ID (Projekt-ID)
$projectPassword = "";  // Your project password

// Optionally specify ref by hand
$ref = 'e971093d-bf88-4241-899d-57df76ad04d5';
$txRef = '';  // Optional transaction reference

if( isset($_GET["ref"]) && empty($ref) ) {
  $ref = $_GET["ref"];
}

if( empty($ref) ) {
  echo "Reference must be given.";
  exit;
}

$strReference = $ref;
$strTxReference = $txRef;

// This part is not normally executed because redirectCustomerToPaymentProvider above
// will end script execution.  You may execute it manually in a separate script.
if( !empty($strReference) ) {
  try {
    $request = new GiroCheckout_SDK_Request( GiroCheckout_SDK_TransactionType_helper::TRANS_TYPE_PAYPAGE_REFUND );
    $request->setSecret($projectPassword);
    $request->addParam('merchantId',$merchantID)
            ->addParam('projectId',$projectID)
            ->addParam('merchantTxId',uniqid())
            ->addParam('amount',2050)
            ->addParam('currency','EUR')
            ->addParam('purpose','Erstattung Nr. 3902')
            ->addParam('reference',$strReference)
            //->addParam('txreference',$strTxReference)
        //the hash field is auto generated by the SDK
            ->submit();

    //echo "<pre>"; print_r($request->getResponseRaw()); echo "</pre><br/>";

    /* if transaction succeeded update your local system and redirect the customer */
    if($request->requestHasSucceeded()) {
       $request->getResponseParam('reference');
       $strResPay = $request->getResponseParam('resultPayment');
       $request->redirectCustomerToPaymentProvider();
    }
    /* if the transaction did not succeed update your local system, get the responsecode and notify the customer */
    else {
       $request->getResponseParam('rc');
       $request->getResponseParam('msg');
       $request->getResponseMessage($request->getResponseParam('rc'),'DE');
    }
  }
  catch (Exception $e) { echo $e->getMessage(); }

}