<?php
/**
 * Sample code for GiroCheckout integration of a paypal refund
 *
 * Call through web server, specify reference in $ref assignment below.
 * Then call without arguments: http://localhost/PaypalRefund.php
 * Optionally, ref may be passed as a GET argument: http://localhost/PaypalRefund.php?ref=bae9f19a-7bfc-4e04-8238-bf52299860d0
 *
 * @filesource
 * @package Samples
 * @version $Revision: 274 $ / $Date: 2019-09-06 14:04:44 -0400 (Fri, 06 Sep 2019) $
 */
require_once '../../GiroCheckout_SDK/GiroCheckout_SDK.php';

/**
 * Configuration of the merchants identifier, project and password
 * this information can be found in the GiroCockpit's project settings
 */
$merchantID = 0;        // Your merchant ID (Verkaufer-ID)
$projectID = 0;         // Your project ID (Projekt-ID)
$projectPassword = "";  // Your project password

if( isset($_GET["ref"]) ) {
  $ref = $_GET["ref"];
}
else {
  // For manual call without arguments, fill reference number here:
  $ref = "bae9f19a-7bfc-4e04-8238-bf52299860d0";
}

if( empty($ref) ) {
  echo "Reference must be given as a parameter.";
  exit;
}

$strReference = $ref;

// This part is not normally executed because redirectCustomerToPaymentProvider above
// will end script execution.  You may execute it manually in a separate script.
if( !empty($strReference) ) {
  try {
    $request = new GiroCheckout_SDK_Request( GiroCheckout_SDK_TransactionType_helper::TRANS_TYPE_PAYPAL_REFUND );
    $request->setSecret($projectPassword);
    $request->addParam('merchantId',$merchantID)
            ->addParam('projectId',$projectID)
            ->addParam('merchantTxId',uniqid())
            ->addParam('amount',1000)
            ->addParam('currency','EUR')
            ->addParam('purpose','Erstattung Nr. 3902')
            ->addParam('reference',$strReference);

    //the hash field is auto generated by the SDK
    $request->submit();

    echo "<pre>"; print_r($request->getResponseRaw()); echo "</pre><br/>";

    /* if transaction succeeded update your local system and redirect the customer */
    if($request->requestHasSucceeded()) {
       //$request->getResponseParam('reference');
       $strResPay = $request->getResponseParam('resultPayment');
       //$request->redirectCustomerToPaymentProvider();
    }
    /* if the transaction did not succeed update your local system, get the responsecode and notify the customer */
    else {
       $request->getResponseParam('rc');
       $request->getResponseParam('msg');
       $request->getResponseMessage($request->getResponseParam('rc'),'DE');
    }
  }
  catch (Exception $e) { echo $e->getMessage(); }

}