<?php
/**
 * Sample code for GiroCheckout integration of a tools test credentials api call
 *
 * @filesource
 * @package Samples
 * @version $Revision$ / $Date$
 */
require_once '../../GiroCheckout_SDK/GiroCheckout_SDK.php';

/**
 * Configuration of the merchants identifier, project and password
 * this information can be found in the GiroCockpit's project settings
 */
$merchantID = 1;        // Your merchant ID (Verkaufer-ID)
$projectID = 2;         // Your project ID (Projekt-ID)
$projectPassword = "3";  // Your project password

$paymentMethodToTest = GiroCheckout_SDK_TransactionType_helper::TRANS_TYPE_CREDITCARD_TRANSACTION;

$strErrInfo = '';
$bIsValid = GiroCheckout_SDK_Tools::testApiCredentials( $paymentMethodToTest, $merchantID, $projectID, $projectPassword, $strErrInfo );

echo "Credentials are <br>" . ($bIsValid ? "VALID" : "NOT VALID") . "<br>";

if( !$bIsValid ) {
  echo "Error Info: $strErrInfo<br>";
}
