<?php
define('__GIROCHECKOUT_SDK_DEBUG__', TRUE);

/**
 * Sample code for GiroCheckout integration of a Apple Pay void transaction
 *
 * Call through web server in two steps:
 * 1) Without arguments for initial SALE transaction: http://localhost/ApplePayVoid.php, copy displayed reference
 * 2) With reference code from SALE for VOID, parameter mode=void, parameter ref for reference:
 * http://localhost/ApplePayVoid.php?mode=void&ref=43290-48329043-43289
 *
 * @filesource
 * @package Samples
 * @version $Revision: 176 $ / $Date: 2017-01-09 13:29:27 -0300 (Mon, 09 Jan 2017) $
 */
require_once '../../GiroCheckout_SDK/GiroCheckout_SDK.php';

/**
 * Configuration of the merchants identifier, project and password
 * this information can be found in the GiroCockpit's project settings
 */
$merchantID = 0;        // Your merchant ID (Verkaufer-ID)
$projectID = 0;         // Your project ID (Projekt-ID)
$projectPassword = "";  // Your project password

$strReference = "831791b2-c9b6-4d6a-91b8-f5932ee5667c";

if (empty($strReference)) {
  echo "Reference must be given.";
  exit;
}

try {
  $request = new GiroCheckout_SDK_Request(GiroCheckout_SDK_TransactionType_helper::TRANS_TYPE_APPLE_PAY_VOID);
  $request->setSecret($projectPassword);
  $request->addParam('merchantId', $merchantID)
    ->addParam('projectId', $projectID)
    ->addParam('merchantTxId', uniqid())
    ->addParam('reference', $strReference)
    //the hash field is auto generated by the SDK
    ->submit();

  echo "<pre>";
  print_r($request->getResponseRaw());
  echo "</pre><br/>";

  /* if transaction succeeded update your local system and redirect the customer */
  if ($request->requestHasSucceeded()) {
    $request->getResponseParam('reference');
    $strResPay = $request->getResponseParam('resultPayment');
    $request->redirectCustomerToPaymentProvider();
  }
  /* if the transaction did not succeed update your local system, get the responsecode and notify the customer */
  else {
    $request->getResponseParam('rc');
    $request->getResponseParam('msg');
    $request->getResponseMessage($request->getResponseParam('rc'), 'DE');
  }
}
catch (Exception $e) {
  echo $e->getMessage();
  echo "<pre>";print_r($request->getResponseRaw());echo "</pre>";
}
