<?php
/**
 * sample code for GiroCheckout integration of a direct debit transaction
 *
 * @filesource
 * @package Samples
 * @version $Revision$ / $Date$
 */
require_once '../../GiroCheckout_SDK/GiroCheckout_SDK.php';

/**
 * configuration of the merchants identifier, project and password
 * this information can be found in the GiroCockpit's project settings
 */
$merchantID = 0;        // Your merchant ID (Verkaufer-ID)
$projectID = 0;         // Your project ID (Projekt-ID)
$projectPassword = "";  // Your project password

/* init direct debit transaction an parameters */
try {
	$request = new GiroCheckout_SDK_Request( GiroCheckout_SDK_TransactionType_helper::TRANS_TYPE_DIRECTDEBIT_WO_PMTPGE );
	$request->setSecret($projectPassword);
	$request->addParam('merchantId',$merchantID)
	        ->addParam('projectId',$projectID)
	        ->addParam('merchantTxId',1234567890)
	        ->addParam('amount',100)
	        ->addParam('currency','EUR')
	        ->addParam('purpose','Lastschrift Transaktion')
	        ->addParam('type','SALE')
	        ->addParam('locale','de_DE_stadtn')  // Locale for payment page for communes
	        ->addParam('mandateReference', '12345abcde')
	        ->addParam('mandateSignedOn', '2014-01-01')
	        ->addParam('mandateReceiverName', 'Max Mustermann Shops')
	        ->addParam('mandateSequence', 1)
	        ->addParam('urlRedirect','https://www.my-domain.de/girocheckout/redirect-directdebit')
	        ->addParam('urlNotify','https://www.my-domain.de/girocheckout/redirect-directdebit')
	    //the hash field is auto generated by the SDK
	        ->submit();

  print_r($request->getResponseRaw()); echo "\n";

	/* if transaction succeeded update your local system an redirect the customer */
	if($request->requestHasSucceeded()) {
    $request->getResponseParam('reference');
    $request->getResponseParam('mandateReference');
    $request->getResponseParam('redirect');

    $request->redirectCustomerToPaymentProvider();
	}
	/* if the transaction did not succeed update your local system, get the responsecode and notify the customer */
	else {
    $request->getResponseParam('rc');
    $request->getResponseParam('msg');
    $request->getResponseMessage($request->getResponseParam('rc'),'DE');
	}
}
catch (Exception $e) { echo $e->getMessage(); }