<?php
/**
 * sample code for GiroCheckout integration of an eps issuer list request
 *
 * @filesource
 * @package Samples
 * @version $Revision: 31 $ / $Date: 2014-06-11 09:55:39 +0200 (Mi, 11 Jun 2014) $
 */
require_once '../../GiroCheckout_SDK/GiroCheckout_SDK.php';

/**
 * configuration of the merchants identifier, project and password
 * this information can be found in the GiroCockpit's project settings
 */
$merchantID = 0;
$projectID = 0;
$projectPassword = "";


/* init eps issuer list request */
try {
	$request = new GiroCheckout_SDK_Request( GiroCheckout_SDK_TransactionType_helper::TRANS_TYPE_EPS_ISSUERLIST );
	$request->setSecret($projectPassword);
	$request->addParam('merchantId',$merchantID)
		    ->addParam('projectId',$projectID)
		    //the hash field is auto generated by the SDK
		    ->submit();

	/* if request succeeded get the issuer list */
	if($request->requestHasSucceeded()) {
	  $request->getResponseParam('issuer');   //now you can parse the array
	}
	/* if the request did not succeed, get the responsecode and notify the customer */
	else {
    //$request->getResponseParam('rc');
    //$request->getResponseParam('msg');
    $msg = $request->getResponseMessage($request->getResponseParam('rc'), 'DE');
    echo "Error: $msg";
	}
}
catch (Exception $e) { echo $e->getMessage(); }