<?php
define('__GIROCHECKOUT_SDK_DEBUG__',true);

/**
 * sample code for GiroCheckout integration of a eps transaction
 *
 * @filesource
 * @package Samples
 * @version $Revision: 41 $ / $Date: 2014-07-01 17:24:29 +0200 (Di, 01 Jul 2014) $
 */
require_once '../../GiroCheckout_SDK/GiroCheckout_SDK.php';

/**
 * configuration of the merchants identifier, project and password
 * this information can be found in the GiroCockpit's project settings
 */
$merchantID = 0;        // Your merchant ID (Verkaufer-ID)
$projectID = 0;         // Your project ID (Projekt-ID)
$projectPassword = "";  // Your project password

/* init eps transaction and parameters */
try {
	$request = new GiroCheckout_SDK_Request( GiroCheckout_SDK_TransactionType_helper::TRANS_TYPE_EPS_TRANSACTION );
	$request->setSecret($projectPassword);
	$request->addParam('merchantId',$merchantID)
	        ->addParam('projectId',$projectID)
	        ->addParam('merchantTxId',"1234567890")
	        ->addParam('amount',100)
	        ->addParam('currency','EUR')
	        ->addParam('purpose','Beispieltransaktion')
	        ->addParam('bic','HYPTAT22')
	        ->addParam('urlRedirect','https://www.my-domain.de/girocheckout/redirect-eps')
	        ->addParam('urlNotify','https://www.my-domain.de/girocheckout/redirect-eps')
	        //the hash field is auto generated by the SDK
	        ->submit();

	/* if transaction succeeded update your local system an redirect the customer */
	if($request->requestHasSucceeded()) {
    $request->getResponseParam('rc');
    $request->getResponseParam('msg');
    $request->getResponseParam('reference');
    $request->getResponseParam('redirect');

    $request->redirectCustomerToPaymentProvider();
	}
	/* if the transaction did not succeed update your local system, get the responsecode and notify the customer */
	else {
    $request->getResponseParam('rc');
    $request->getResponseParam('msg');
    $request->getResponseMessage($request->getResponseParam('rc'),'DE');
	}
}
catch (Exception $e) { echo $e->getMessage(); }