<?php
define('__GIROCHECKOUT_SDK_DEBUG__', TRUE);

/**
 * Sample code for GiroCheckout integration of a Google pay capture transaction
 *
 * Call through web server in two steps:
 * 1) Without arguments for initial AUTH transaction: http://localhost/GooglePayCapture.php, copy displayed reference
 * 2) With reference code from AUTH for CAPTURE, parameter mode=cap (for capture), parameter ref for reference:
 * http://localhost/GooglePayCapture.php?mode=cap&ref=43290-48329043-43289
 *
 * @filesource
 * @package Samples
 * @version $Revision: 274 $ / $Date: 2019-09-06 14:04:44 -0400 (Fri, 06 Sep 2019) $
 */
require_once '../../GiroCheckout_SDK/GiroCheckout_SDK.php';

/**
 * configuration of the merchants identifier, project and password
 * this information can be found in the GiroCockpit's project settings
 */
$merchantID = 0;        // Your merchant ID (Verkaufer-ID)
$projectID = 0;         // Your project ID (Projekt-ID)
$projectPassword = "";  // Your project password

$strReference = "3b57d6e2-58e2-470c-b5fc-e048a077886d";

if (empty($strReference)) {
  echo "Reference must be given.";
  exit;
}

try {
  $request = new GiroCheckout_SDK_Request(GiroCheckout_SDK_TransactionType_helper::TRANS_TYPE_GOOGLE_PAY_CAPTURE);
  $request->setSecret($projectPassword);
  $request->addParam('merchantId', $merchantID)
    ->addParam('projectId', $projectID)
    ->addParam('merchantTxId', uniqid())
    ->addParam('amount', 100)
    ->addParam('currency', 'EUR')
    ->addParam('purpose', 'Capture für Bsptrx')
    ->addParam('reference', $strReference)
    //the hash field is auto generated by the SDK
    ->submit();

  echo "<pre>";
  print_r($request->getResponseRaw());
  echo "</pre><br/>";

  /* if transaction succeeded update your local system and redirect the customer */
  if ($request->requestHasSucceeded()) {
    $request->getResponseParam('reference');
    $strResPay = $request->getResponseParam('resultPayment');
    $request->redirectCustomerToPaymentProvider();
  }

  /* if the transaction did not succeed update your local system, get the responsecode and notify the customer */
  else {
    $request->getResponseParam('rc');
    $request->getResponseParam('msg');
    $request->getResponseMessage($request->getResponseParam('rc'), 'DE');
  }
}
catch (Exception $e) {
  echo $e->getMessage();
  echo "<pre>";
  print_r($request->getResponseRaw());
  echo "</pre>";
}
