<?php
define('__GIROCHECKOUT_SDK_DEBUG__',true);

/**
 * Sample code for GiroCheckout integration of a paypage transaction, to capture a previous authorization/reservation.
 *
 * Call through web server:
 * a) With reference code from AUTH for CAPTURE, parameter ref for reference to transaction to capture
 * http://localhost/PaypageCapture.php?ref=43290-48329043-43289
 * b) Put reference directly into this file and call only http://localhost/PaypageCapture.php
 * 
 * @filesource
 * @package Samples
 * @version $Revision: 274 $ / $Date: 2019-09-06 14:04:44 -0400 (Fri, 06 Sep 2019) $
 */
require_once '../../GiroCheckout_SDK/GiroCheckout_SDK.php';

/**
 * configuration of the merchants identifier, project and password
 * this information can be found in the GiroCockpit's project settings
 */
$merchantID = 0;        // Your merchant ID (Verkaufer-ID)
$projectID = 0;         // Your project ID (Projekt-ID)
$projectPassword = "";  // Your project password

$strReference = '3552d52f-4eea-4e2b-b87c-f737a89f187c';  // Reference to original PAYPAGE transaction to capture
$strTxReference = '';  // Optional reference to specific transaction (e.g. credit card) if paypage reference is not enough

$ref = $strReference;
if( isset($_GET["ref"]) && empty($ref) ) {
  $ref = $_GET["ref"];
}

$aTdsOptionalInfo = new stdClass();
$aTdsOptionalInfo->email = "myemail@example.com"; // Optional email address
$aTdsOptionalInfo->addressesMatch = "false"; // Shipping address matches billing address, array( "true", "false" );


if( !isset($ref) ) {
  echo "Reference must be given.";
  exit;
}

// This part is not normally executed because redirectCustomerToPaymentProvider above
// will end script execution.  You may execute it manually in a separate script.
if( !empty($strReference) ) {
  try {
    $request = new GiroCheckout_SDK_Request( GiroCheckout_SDK_TransactionType_helper::TRANS_TYPE_PAYPAGE_CAPTURE );
    $request->setSecret($projectPassword);
    $request->addParam('merchantId',$merchantID)
            ->addParam('projectId',$projectID)
            ->addParam('merchantTxId',uniqid())
            ->addParam('amount',100)
            ->addParam('currency','EUR')
            ->addParam('purpose','Capture für Bsptrx')
            ->addParam('reference',$ref)
            //->addParam('txreference',$strTxReference)
        //the hash field is auto generated by the SDK
            ->submit();

    //echo "<pre>"; print_r($request->getResponseRaw()); echo "</pre><br/>";

    /* if transaction succeeded update your local system and redirect the customer */
    if($request->requestHasSucceeded()) {
       $request->getResponseParam('reference');
       $strResPay = $request->getResponseParam('resultPayment');
       $request->redirectCustomerToPaymentProvider();
    }

    /* if the transaction did not succeed update your local system, get the responsecode and notify the customer */
    else {
       $request->getResponseParam('rc');
       $request->getResponseParam('msg');
       $request->getResponseMessage($request->getResponseParam('rc'),'DE');
    }
  }
  catch (Exception $e) { echo $e->getMessage(); }
}