<?php
/**
 * Sample code for GiroCheckout integration of a Payment Page Donation certificate call.
 *
 * @filesource
 * @package Samples
 * @version $Revision: 156 $ / $Date: 2016-06-29 14:17:03 -0300 (Mi, 29 Jun 2016) $
 */
require_once '../../GiroCheckout_SDK/GiroCheckout_SDK.php';

/**
 * Configuration of the merchants identifier, project and password
 * this information can be found in the GiroCockpit's project settings
 */
$merchantID = 0;        // Your merchant ID (Verkaufer-ID)
$projectID = 0;         // Your project ID (Projekt-ID)
$projectPassword = "";  // Your project password

$strTransactionReference = "";  // Insert GiroCheckout Reference (UUID) of the related transaction (reference value of trx init)

/* init paypage projects request */
try {
	$request = new GiroCheckout_SDK_Request( GiroCheckout_SDK_TransactionType_helper::TRANS_TYPE_PAYPAGE_DONATIONCERT );
	$request->setSecret($projectPassword);
	$request->addParam('merchantId',$merchantID)
	    ->addParam('projectId',$projectID)
	    ->addParam('reference',$strTransactionReference)
	    //->addParam('company', 'My Company Inc.')  // Optional company name
	    ->addParam('firstname', 'Karolin')
	    ->addParam('lastname', 'Mueller')
	    ->addParam('address', 'Hinter dem Damm 2')
	    ->addParam('zip', '10115')
	    ->addParam('city', 'Berlin')
	    ->addParam('country', 'DE')
	    ->addParam('email', 'example@example.com')

	    //the hash field is auto generated by the SDK
	    ->submit();

  //echo "<pre>";print_r($request->getResponseRaw());echo "</pre>";

	/* if request succeeded get the issuer list */
	if($request->requestHasSucceeded()) {
    echo "Success! Return code: " . $request->getResponseParam('rc');
	}
	/* if the request did not succeed, get the responsecode and notify the customer */
	else {
    //$request->getResponseParam('rc');
    //$request->getResponseParam('msg');
    $msg = $request->getResponseMessage($request->getResponseParam('rc'), 'DE');
    echo "Code: ".$request->getResponseParam('rc').", Error: $msg";
	}
}
catch (Exception $e) {
  echo "Exception: " . $e->getMessage();
}