<?php
/**
 * Sample code for GiroCheckout integration of a tools get transaction api call
 *
 * @filesource
 * @package Samples
 * @version $Revision$ / $Date$
 */
require_once '../../GiroCheckout_SDK/GiroCheckout_SDK.php';

/**
 * Configuration of the merchants identifier, project and password
 * this information can be found in the GiroCockpit's project settings
 */
$merchantID = 0;        // Your merchant ID (Verkaufer-ID)
$projectID = 0;         // Your project ID (Projekt-ID)
$projectPassword = "";  // Your project password

/* get transaction information */
try {
	$request = new GiroCheckout_SDK_Request( GiroCheckout_SDK_TransactionType_helper::TRANS_TYPE_GET_TRANSACTIONTOOL );
	$request->setSecret($projectPassword);
	$request->addParam('merchantId',$merchantID)
	        ->addParam('projectId',$projectID)
	        ->addParam('reference','4a918722-05b2-4daa-92e7-5d47441e09b5')
	    //the hash field is auto generated by the SDK
	        ->submit();
	
	
	/* if request succeeded*/
	if($request->requestHasSucceeded())	{
    $request->getResponseParam('rc');
    $request->getResponseParam('msg');
    $request->getResponseParam('reference');
    $request->getResponseParam('merchantTxId');
    $request->getResponseParam('backendTxId');
    $request->getResponseParam('amount');
    $request->getResponseParam('currency');
    $request->getResponseParam('resultPayment');
    $request->getResponseParam('resultAVS');
    $request->getResponseParam('obvName');
	}
	/* if the request did not succeed */
	else {
    $request->getResponseParam('rc');
    $request->getResponseParam('msg');
    $request->getResponseMessage($request->getResponseParam('rc'),'DE');
	}
}
catch (Exception $e) { echo $e->getMessage(); }