<?php
define('__GIROCHECKOUT_SDK_DEBUG__',true);

/**
 * Sample code for GiroCheckout integration of a WERO refund
 *
 * @filesource
 * @package Samples
 * @version $Revision: 274 $ / $Date: 2019-09-06 14:04:44 -0400 (Fri, 06 Sep 2019) $
 */
require_once '../../GiroCheckout_SDK/GiroCheckout_SDK.php';

$strReference = "9777a1a9-95f8-46e2-a479-8abaabd0d27a";

/**
 * Configuration of the merchants identifier, project and password
 * this information can be found in the GiroCockpit's project settings
 */
$merchantID = 0;        // Your merchant ID (Verkaufer-ID)
$projectID = 0;         // Your project ID (Projekt-ID)
$projectPassword = "";  // Your project password

/* init giropay transaction and parameters */
try {
  $request = new GiroCheckout_SDK_Request( GiroCheckout_SDK_TransactionType_helper::TRANS_TYPE_WERO_REFUND );
  $request->setSecret($projectPassword);

  $request->addParam('merchantId',$merchantID)
        ->addParam('projectId',$projectID)
        ->addParam('merchantTxId',"1234567890123456789012")
        ->addParam('amount',300)
        ->addParam('currency','EUR')
        ->addParam('purpose','WERO Refund Test ' . random_int(100,999))
        ->addParam('reference', $strReference)

      //the hash field is auto generated by the SDK
      ->submit();

  echo "<pre>";print_r($request->getResponseRaw());echo "</pre>";

	/* if transaction succeeded, update your local system an redirect the customer */
	if($request->requestHasSucceeded()) {
        $rc = $request->getResponseParam('rc');

        $request->getResponseParam('msg');
        $request->getResponseParam('reference');
        $request->getResponseParam('redirect');

        $request->redirectCustomerToPaymentProvider();
	}
	/* if the transaction did not succeed update your local system, get the responsecode and notify the customer */
	else {
        echo $request->getResponseParam('rc') . " WeroRefund.php" . $request->getResponseParam('msg') . "\n";
	}
}
catch (Exception $e) {
  echo "Exception: <br>";
  echo $e->getMessage();

  echo "<pre>";print_r($request->getResponseRaw());echo "</pre>";
}